/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.events;

import com.utility.ConvertStr;
import com.utility.DbLogin;
import com.webhook.events.BaseChangeFieldGenerator;
import com.webhook.util.CDCTables;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResDetailChangeField
extends BaseChangeFieldGenerator {
    private static final Logger log = LoggerFactory.getLogger(ResDetailChangeField.class);
    private final String articleCodeFieldName = "A_CODE";

    ResDetailChangeField(DbLogin dbLogin) {
        super(dbLogin);
    }

    protected void addToChangedFields(Map<String, Object> payload, CDCTables changedTable) {
        Map article = this.getArticleFromResDetail(payload);
        if (article == null) {
            log.info("TncCDC: tried to get new inventory value after res detail changed but the product didn't exist in W_ShowArticleForSearch_Big");
            return;
        }
        article.put(changedTable.getTableCodeFieldToShow(), ConvertStr.encrypt((String)article.get("A_CODE").toString()));
        article.remove("A_CODE");
        this.changedFields = article;
    }

    @Nullable
    private Map<String, Object> getArticleFromResDetail(@NotNull Map<String, Object> payload) {
        String aCode = String.valueOf(payload.get("a_code"));
        List inventoryResult = this.getJdbcTemplate().queryForList(" SELECT DISTINCT ROUND([EXIST], 3) [inventory], [A_CODE] from W_ShowArticleForSearch_Big WHERE A_CODE = ?", new Object[]{aCode});
        if (!inventoryResult.isEmpty()) {
            return (Map)inventoryResult.get(0);
        }
        return null;
    }
}

